/*
 * Decompiled with CFR 0.152.
 */
package com.octopusdragon.projects.battleship;

import com.octopusdragon.projects.battleship.Board;
import com.octopusdragon.projects.battleship.Orientation;
import com.octopusdragon.projects.battleship.Ship;
import com.octopusdragon.projects.battleship.Tile;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.stage.Stage;

public class Battleship
extends Application {
    static final int ROWS = 9;
    static final int COLS = 9;
    static final double LENGTH = 50.0;
    static final double SPACING = 30.0;
    static final double PADDING = 35.0;
    static Label titleLabel;
    static Label fleetLabel;
    static ImageView carrierImage;
    static ImageView battleshipImage;
    static ImageView destroyerImage;
    static ImageView submarineImage;
    static ImageView patrolImage;
    static ImageView curShipImage;
    static Tile[][] grid;
    static Label messageLabel;
    static Button nextButton;
    static Board player1;
    static Board player2;
    static Board curPlayer;
    static Ship curShip;
    static Orientation curDir;
    static int curRow;
    static int curCol;
    static boolean badLoc;
    static boolean setup;
    static boolean went;
    static boolean won;

    static {
        setup = false;
        went = false;
        won = false;
    }

    public void start(Stage primaryStage) {
        titleLabel = new Label();
        titleLabel.setFont(new Font("Stencil", 40.0));
        fleetLabel = new Label("Fleet");
        fleetLabel.setFont(new Font("Stencil", 30.0));
        carrierImage = new ImageView(new Image("carrier.png"));
        carrierImage.setOnMouseClicked((EventHandler)new ShipClickHandler());
        battleshipImage = new ImageView(new Image("battleship.png"));
        battleshipImage.setOnMouseClicked((EventHandler)new ShipClickHandler());
        destroyerImage = new ImageView(new Image("destroyer.png"));
        destroyerImage.setOnMouseClicked((EventHandler)new ShipClickHandler());
        submarineImage = new ImageView(new Image("submarine.png"));
        submarineImage.setOnMouseClicked((EventHandler)new ShipClickHandler());
        patrolImage = new ImageView(new Image("patrol.png"));
        patrolImage.setOnMouseClicked((EventHandler)new ShipClickHandler());
        VBox shipBox = new VBox(new Node[]{fleetLabel, carrierImage, battleshipImage, destroyerImage, submarineImage, patrolImage});
        shipBox.setAlignment(Pos.CENTER_LEFT);
        shipBox.setSpacing(30.0);
        grid = new Tile[9][9];
        GridPane gridPane = new GridPane();
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                Battleship.grid[i][j] = new Tile(50.0);
                grid[i][j].setOnMouseClicked(new TileClickHandler());
                grid[i][j].setOnMouseEntered(new TileHoverHandler());
                gridPane.add((Node)grid[i][j], j, i);
                ++j;
            }
            ++i;
        }
        gridPane.setGridLinesVisible(true);
        HBox boardBox = new HBox(new Node[]{shipBox, gridPane});
        boardBox.setSpacing(30.0);
        messageLabel = new Label();
        messageLabel.setFont(new Font("Stencil", 20.0));
        nextButton = new Button();
        nextButton.setFont(new Font("Stencil", 30.0));
        nextButton.setOnAction((EventHandler)new NextButtonHandler());
        VBox vbox = new VBox(new Node[]{titleLabel, boardBox, messageLabel, nextButton});
        vbox.setAlignment(Pos.CENTER);
        vbox.setSpacing(30.0);
        vbox.setPadding(new Insets(35.0));
        Scene scene = new Scene((Parent)vbox);
        scene.setOnScroll((EventHandler)new ScrollHandler());
        scene.setOnKeyPressed((EventHandler)new ArrowHandler());
        primaryStage.setScene(scene);
        primaryStage.setTitle("Battleship");
        primaryStage.show();
        this.newGame();
    }

    public void newGame() {
        player1 = new Board(9, 9);
        player2 = new Board(9, 9);
        setup = false;
        won = false;
        went = false;
        nextButton.setText("Next");
        nextButton.setDisable(true);
        curPlayer = player1;
        this.prepare();
    }

    public void prepare() {
        if (curPlayer == player1) {
            titleLabel.setText("Player 1's Board");
            messageLabel.setText("P1, place your ships.");
        } else if (curPlayer == player2) {
            titleLabel.setText("Player 2's Board");
            messageLabel.setText("P2, place your ships.");
        }
        carrierImage.setImage(new Image("carrier.png"));
        battleshipImage.setImage(new Image("battleship.png"));
        destroyerImage.setImage(new Image("destroyer.png"));
        submarineImage.setImage(new Image("submarine.png"));
        patrolImage.setImage(new Image("patrol.png"));
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                grid[i][j].setText("", null);
                grid[i][j].setColor(null);
                ++j;
            }
            ++i;
        }
        went = false;
        nextButton.setDisable(true);
    }

    public void nextTurn() {
        if (curPlayer == player2) {
            curPlayer = player1;
            titleLabel.setText("Player 1's Board");
            messageLabel.setText("Player 2's turn.");
        } else if (curPlayer == player1) {
            curPlayer = player2;
            titleLabel.setText("Player 2's Board");
            messageLabel.setText("Player 1's turn.");
        }
        if (curPlayer.fleet().carrier().isSunk()) {
            carrierImage.setImage(new Image("carrier_empty.png"));
        } else {
            carrierImage.setImage(new Image("carrier.png"));
        }
        if (curPlayer.fleet().battleship().isSunk()) {
            battleshipImage.setImage(new Image("battleship_empty.png"));
        } else {
            battleshipImage.setImage(new Image("battleship.png"));
        }
        if (curPlayer.fleet().destroyer().isSunk()) {
            destroyerImage.setImage(new Image("destroyer_empty.png"));
        } else {
            destroyerImage.setImage(new Image("destroyer.png"));
        }
        if (curPlayer.fleet().submarine().isSunk()) {
            submarineImage.setImage(new Image("submarine_empty.png"));
        } else {
            submarineImage.setImage(new Image("submarine.png"));
        }
        if (curPlayer.fleet().patrol().isSunk()) {
            patrolImage.setImage(new Image("patrol_empty.png"));
        } else {
            patrolImage.setImage(new Image("patrol.png"));
        }
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                if (curPlayer.getShot(i, j) && curPlayer.getOccupied(i, j)) {
                    grid[i][j].setText("O", Color.RED);
                } else if (curPlayer.getShot(i, j) && !curPlayer.getOccupied(i, j)) {
                    grid[i][j].setText("X", Color.GRAY);
                } else {
                    grid[i][j].setText("", null);
                }
                ++j;
            }
            ++i;
        }
        went = false;
        nextButton.setDisable(true);
    }

    public void place(MouseEvent event) {
        if (badLoc) {
            return;
        }
        if (curShipImage == carrierImage) {
            carrierImage.setImage(new Image("carrier_empty.png"));
        } else if (curShipImage == battleshipImage) {
            battleshipImage.setImage(new Image("battleship_empty.png"));
        } else if (curShipImage == destroyerImage) {
            destroyerImage.setImage(new Image("destroyer_empty.png"));
        } else if (curShipImage == submarineImage) {
            submarineImage.setImage(new Image("submarine_empty.png"));
        } else if (curShipImage == patrolImage) {
            patrolImage.setImage(new Image("patrol_empty.png"));
        }
        if (curDir == Orientation.E) {
            int i = 0;
            while (i < curShip.length()) {
                curPlayer.setShip(curShip, curRow, curCol + i);
                curShip.setLocation(curRow, curCol + i);
                grid[curRow][curCol + i].setColor(Color.BLACK);
                ++i;
            }
        } else if (curDir == Orientation.S) {
            int i = 0;
            while (i < curShip.length()) {
                curPlayer.setShip(curShip, curRow + i, curCol);
                curShip.setLocation(curRow + i, curCol);
                grid[curRow + i][curCol].setColor(Color.BLACK);
                ++i;
            }
        } else if (curDir == Orientation.W) {
            int i = 0;
            while (i < curShip.length()) {
                curPlayer.setShip(curShip, curRow, curCol - i);
                curShip.setLocation(curRow, curCol - i);
                grid[curRow][curCol - i].setColor(Color.BLACK);
                ++i;
            }
        } else if (curDir == Orientation.N) {
            int i = 0;
            while (i < curShip.length()) {
                curPlayer.setShip(curShip, curRow - i, curCol);
                curShip.setLocation(curRow - i, curCol);
                grid[curRow - i][curCol].setColor(Color.BLACK);
                ++i;
            }
        }
        curShip = null;
        if (curPlayer.fleet().allPlaced()) {
            nextButton.setDisable(false);
        }
    }

    public void shoot(MouseEvent event) {
        if (won || went || curPlayer.getShot(curRow, curCol)) {
            return;
        }
        curPlayer.shoot(curRow, curCol);
        if (curPlayer.getOccupied(curRow, curCol)) {
            grid[curRow][curCol].setText("O", Color.RED);
            if (curPlayer.getShip(curRow, curCol).isSunk()) {
                messageLabel.setText("You sunk the " + curPlayer.getShip(curRow, curCol).getName() + "!");
                if (curPlayer.fleet().carrier().isSunk()) {
                    carrierImage.setImage(new Image("carrier_empty.png"));
                }
                if (curPlayer.fleet().battleship().isSunk()) {
                    battleshipImage.setImage(new Image("battleship_empty.png"));
                }
                if (curPlayer.fleet().destroyer().isSunk()) {
                    destroyerImage.setImage(new Image("destroyer_empty.png"));
                }
                if (curPlayer.fleet().submarine().isSunk()) {
                    submarineImage.setImage(new Image("submarine_empty.png"));
                }
                if (curPlayer.fleet().patrol().isSunk()) {
                    patrolImage.setImage(new Image("patrol_empty.png"));
                }
            } else {
                messageLabel.setText("Hit!");
            }
        } else {
            grid[curRow][curCol].setText("X", Color.GRAY);
            messageLabel.setText("Miss...");
        }
        grid[curRow][curCol].setColor(null);
        boolean remainingShip = false;
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                if (curPlayer.getOccupied(i, j) && !curPlayer.getShot(i, j)) {
                    remainingShip = true;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (!remainingShip) {
            won = true;
        }
        went = true;
        nextButton.setDisable(false);
        if (won) {
            if (curPlayer == player2) {
                messageLabel.setText("P1 won!!!");
            } else if (curPlayer == player1) {
                messageLabel.setText("P2 won!!!");
            }
            nextButton.setText("New Game");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void highlightToPlace() {
        block35: {
            if (Battleship.curShip != null) {
                block37: {
                    block36: {
                        i = 0;
                        while (i < 9) {
                            j = 0;
                            while (j < 9) {
                                if (Battleship.curPlayer.getOccupied(i, j)) {
                                    Battleship.grid[i][j].setColor(Color.BLACK);
                                } else {
                                    Battleship.grid[i][j].setColor(null);
                                }
                                ++j;
                            }
                            ++i;
                        }
                        try {
                            if (Battleship.curDir == Orientation.E) {
                                i = 0;
                                while (i < Battleship.curShip.length()) {
                                    if (Battleship.grid[Battleship.curRow][Battleship.curCol + i].getColor() == Color.BLACK) {
                                        throw new ArrayIndexOutOfBoundsException();
                                    }
                                    Battleship.grid[Battleship.curRow][Battleship.curCol + i].setColor(Color.BLUE);
                                    ++i;
                                }
                            } else if (Battleship.curDir == Orientation.S) {
                                i = 0;
                                while (i < Battleship.curShip.length()) {
                                    if (Battleship.grid[Battleship.curRow + i][Battleship.curCol].getColor() == Color.BLACK) {
                                        throw new ArrayIndexOutOfBoundsException();
                                    }
                                    Battleship.grid[Battleship.curRow + i][Battleship.curCol].setColor(Color.BLUE);
                                    ++i;
                                }
                            } else if (Battleship.curDir == Orientation.W) {
                                i = 0;
                                while (i < Battleship.curShip.length()) {
                                    if (Battleship.grid[Battleship.curRow][Battleship.curCol - i].getColor() == Color.BLACK) {
                                        throw new ArrayIndexOutOfBoundsException();
                                    }
                                    Battleship.grid[Battleship.curRow][Battleship.curCol - i].setColor(Color.BLUE);
                                    ++i;
                                }
                            } else if (Battleship.curDir == Orientation.N) {
                                i = 0;
                                while (i < Battleship.curShip.length()) {
                                    if (Battleship.grid[Battleship.curRow - i][Battleship.curCol].getColor() == Color.BLACK) {
                                        throw new ArrayIndexOutOfBoundsException();
                                    }
                                    Battleship.grid[Battleship.curRow - i][Battleship.curCol].setColor(Color.BLUE);
                                    ++i;
                                }
                            }
                            Battleship.badLoc = false;
                            break block35;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            if (Battleship.curDir != Orientation.E) break block36;
                            i = 0;
                            ** while (i < Battleship.curShip.length())
                        }
lbl-1000:
                        // 1 sources

                        {
                            if (Battleship.curCol + i < 9) {
                                Battleship.grid[Battleship.curRow][Battleship.curCol + i].setColor(Color.RED);
                                ++i;
                                continue;
                            }
lbl60:
                            // 3 sources

                            break block37;
                        }
                    }
                    if (Battleship.curDir == Orientation.S) {
                        i = 0;
                        while (i < Battleship.curShip.length()) {
                            if (Battleship.curRow + i < 9) {
                                Battleship.grid[Battleship.curRow + i][Battleship.curCol].setColor(Color.RED);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else if (Battleship.curDir == Orientation.W) {
                        i = 0;
                        while (i < Battleship.curShip.length()) {
                            if (Battleship.curCol - i >= 0) {
                                Battleship.grid[Battleship.curRow][Battleship.curCol - i].setColor(Color.RED);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else if (Battleship.curDir == Orientation.N) {
                        i = 0;
                        while (i < Battleship.curShip.length()) {
                            if (Battleship.curRow - i >= 0) {
                                Battleship.grid[Battleship.curRow - i][Battleship.curCol].setColor(Color.RED);
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                }
                Battleship.badLoc = true;
            }
        }
    }

    public void highlightToShoot() {
        int i = 0;
        while (i < 9) {
            int j = 0;
            while (j < 9) {
                grid[i][j].setColor(null);
                ++j;
            }
            ++i;
        }
        grid[curRow][curCol].setColor(Color.YELLOW);
    }

    public static void main(String[] args) {
        Battleship.launch((String[])args);
    }

    public class ArrowHandler
    implements EventHandler<KeyEvent> {
        public void handle(KeyEvent event) {
            if (curShip == null) {
                return;
            }
            if (event.getCode() == KeyCode.RIGHT) {
                if (curDir == Orientation.E) {
                    curDir = Orientation.S;
                } else if (curDir == Orientation.S) {
                    curDir = Orientation.W;
                } else if (curDir == Orientation.W) {
                    curDir = Orientation.N;
                } else if (curDir == Orientation.N) {
                    curDir = Orientation.E;
                }
            } else if (event.getCode() == KeyCode.LEFT) {
                if (curDir == Orientation.E) {
                    curDir = Orientation.N;
                } else if (curDir == Orientation.N) {
                    curDir = Orientation.W;
                } else if (curDir == Orientation.W) {
                    curDir = Orientation.S;
                } else if (curDir == Orientation.S) {
                    curDir = Orientation.E;
                }
            }
            if (curShip != null) {
                Battleship.this.highlightToPlace();
            }
        }
    }

    public class NextButtonHandler
    implements EventHandler<ActionEvent> {
        public void handle(ActionEvent event) {
            if (!setup) {
                if (curPlayer == player1) {
                    curPlayer = player2;
                    Battleship.this.prepare();
                } else {
                    setup = true;
                    curPlayer = player1;
                    int i = 0;
                    while (i < 9) {
                        int j = 0;
                        while (j < 9) {
                            grid[i][j].setColor(null);
                            ++j;
                        }
                        ++i;
                    }
                    Battleship.this.nextTurn();
                }
            } else if (won) {
                Battleship.this.newGame();
            } else {
                Battleship.this.nextTurn();
            }
        }
    }

    public class ScrollHandler
    implements EventHandler<ScrollEvent> {
        public void handle(ScrollEvent event) {
            if (curShip == null) {
                return;
            }
            if (event.getDeltaY() < 0.0) {
                if (curDir == Orientation.E) {
                    curDir = Orientation.S;
                } else if (curDir == Orientation.S) {
                    curDir = Orientation.W;
                } else if (curDir == Orientation.W) {
                    curDir = Orientation.N;
                } else if (curDir == Orientation.N) {
                    curDir = Orientation.E;
                }
            } else if (event.getDeltaY() > 0.0) {
                if (curDir == Orientation.E) {
                    curDir = Orientation.N;
                } else if (curDir == Orientation.N) {
                    curDir = Orientation.W;
                } else if (curDir == Orientation.W) {
                    curDir = Orientation.S;
                } else if (curDir == Orientation.S) {
                    curDir = Orientation.E;
                }
            }
            if (curShip != null) {
                Battleship.this.highlightToPlace();
            }
        }
    }

    public class ShipClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            curShipImage = (ImageView)event.getSource();
            if (curShipImage == carrierImage && !curPlayer.fleet().carrier().isPlaced()) {
                curShip = curPlayer.fleet().carrier();
            } else if (curShipImage == battleshipImage && !curPlayer.fleet().battleship().isPlaced()) {
                curShip = curPlayer.fleet().battleship();
            } else if (curShipImage == destroyerImage && !curPlayer.fleet().destroyer().isPlaced()) {
                curShip = curPlayer.fleet().destroyer();
            } else if (curShipImage == submarineImage && !curPlayer.fleet().submarine().isPlaced()) {
                curShip = curPlayer.fleet().submarine();
            } else if (curShipImage == patrolImage && !curPlayer.fleet().patrol().isPlaced()) {
                curShip = curPlayer.fleet().patrol();
            }
            curDir = Orientation.E;
        }
    }

    public class TileClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (curShip != null) {
                Battleship.this.place(event);
            } else if (setup) {
                Battleship.this.shoot(event);
            }
        }
    }

    public class TileHoverHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            curRow = GridPane.getRowIndex((Node)((Tile)((Object)event.getSource())));
            curCol = GridPane.getColumnIndex((Node)((Tile)((Object)event.getSource())));
            if (curShip != null) {
                Battleship.this.highlightToPlace();
            } else if (setup && !went) {
                Battleship.this.highlightToShoot();
            }
        }
    }
}

