/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.backgammon.gui;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import tech.octopusdragon.proj.backgammon.Man;
import tech.octopusdragon.proj.backgammon.gui.BackgammonApplication;
import tech.octopusdragon.proj.backgammon.gui.GhostPiece;
import tech.octopusdragon.proj.backgammon.gui.Piece;
import tech.octopusdragon.proj.backgammon.gui.PointGraphic;

public class Space
extends StackPane {
    private StartingPlace start;
    private int pointIndex;
    private GridPane gridPane;
    private List<Piece> pieces;
    private GhostPiece ghostPiece;

    public Space(StartingPlace start, int pointIndex, boolean point) {
        this.start = start;
        this.pointIndex = pointIndex;
        this.gridPane = new GridPane();
        this.pieces = new ArrayList<Piece>();
        if (point) {
            PointGraphic.Direction dir = start == StartingPlace.TOP ? PointGraphic.Direction.S : PointGraphic.Direction.N;
            PointGraphic triangle = new PointGraphic(dir, 60.0, 300.0, (Paint)(pointIndex % 2 == 1 ? BackgammonApplication.POINT1_COLOR : BackgammonApplication.POINT2_COLOR));
            GridPane.setRowSpan((Node)triangle, (Integer)5);
            this.gridPane.add((Node)triangle, 0, 0);
        }
        int i = 0;
        while (i < 5) {
            this.gridPane.add((Node)new Rectangle(60.0, 60.0, (Paint)Color.TRANSPARENT), 0, i);
            ++i;
        }
        this.getChildren().add((Object)this.gridPane);
    }

    public Space(StartingPlace start, int pointIndex, boolean point, int numMen, Man type) {
        this(start, pointIndex, point);
        int i = 0;
        while (i < numMen) {
            this.add(type);
            ++i;
        }
    }

    public int getPointIndex() {
        return this.pointIndex;
    }

    public void add(Man type) {
        Piece newPiece = new Piece(60.0, this.pieces.size() / 5 + 1, type);
        this.gridPane.add((Node)newPiece, 0, this.nextSpot());
        this.pieces.add(newPiece);
    }

    public void remove() {
        this.gridPane.getChildren().remove((Object)this.pieces.get(this.pieces.size() - 1));
        this.pieces.remove(this.pieces.size() - 1);
    }

    public int nextSpot() {
        if (this.start == StartingPlace.TOP) {
            return this.pieces.size() % 5;
        }
        return 4 - this.pieces.size() % 5;
    }

    public int lastSpot() {
        if (this.pieces.isEmpty()) {
            return -1;
        }
        if (this.start == StartingPlace.TOP) {
            return 5 - (this.pieces.size() - 1) % 5;
        }
        return (this.pieces.size() - 1) % 5;
    }

    public void highlightPiece() {
        if (!this.pieces.isEmpty()) {
            this.pieces.get(this.pieces.size() - 1).highlight();
        }
    }

    public void highlightSpace() {
        if (this.pieces.size() >= 5) {
            this.pieces.get(this.pieces.size() - 5).highlight();
        } else {
            this.ghostPiece = new GhostPiece(60.0);
            GridPane.setHalignment((Node)this.ghostPiece, (HPos)HPos.CENTER);
            GridPane.setValignment((Node)this.ghostPiece, (VPos)VPos.CENTER);
            this.gridPane.add((Node)this.ghostPiece, 0, this.nextSpot());
        }
    }

    public void select() {
        if (!this.pieces.isEmpty()) {
            this.pieces.get(this.pieces.size() - 1).select();
        }
    }

    public void removeEffect() {
        if (this.ghostPiece != null) {
            this.gridPane.getChildren().remove((Object)this.ghostPiece);
            this.ghostPiece = null;
        }
        if (!this.pieces.isEmpty()) {
            this.pieces.get(this.pieces.size() - 1).removeEffect();
        }
        if (this.pieces.size() >= 5) {
            this.pieces.get(this.pieces.size() - 5).removeEffect();
        }
    }

    public double getLastPieceLayoutX() {
        return this.pieces.get(this.pieces.size() - 1).getLayoutX();
    }

    public double getLastPieceLayoutY() {
        return this.pieces.get(this.pieces.size() - 1).getLayoutY();
    }

    public double getNextPieceLayoutX() {
        return 0.0;
    }

    public double getNextPieceLayoutY() {
        if (this.pieces.size() >= 5) {
            return this.pieces.get(this.pieces.size() - 5).getLayoutY();
        }
        if (this.start == StartingPlace.TOP) {
            return 60.0 * (double)this.pieces.size();
        }
        return 240.0 - 60.0 * (double)this.pieces.size();
    }

    public static enum StartingPlace {
        TOP,
        BOTTOM;

    }
}

