/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.backgammon.gui;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import tech.octopusdragon.proj.backgammon.Man;

public class Piece
extends Group {
    private static final Color BLACK_COLOR = Color.GRAY;
    private static final Color WHITE_COLOR = Color.WHITE;
    private static final Color SELECT_COLOR = Color.YELLOW;
    private static final Color HIGHLIGHT_COLOR = Color.YELLOW;
    private static final double FADE_DURATION = 1500.0;
    private double size;
    private boolean highlighted;
    private boolean selected;
    Circle outerCircle;
    Circle innerCircle;
    InnerShadow innerShadow;
    Circle concavity;

    public Piece(double size, int stackSize, Man type) {
        this.size = size;
        this.highlighted = false;
        this.selected = false;
        Color fill = type == Man.BLACK ? BLACK_COLOR : WHITE_COLOR;
        double edgeWidth = 0.0;
        if (stackSize == 1) {
            edgeWidth = size / 18.0;
        } else if (stackSize == 2) {
            edgeWidth = size / 6.0;
        } else if (stackSize == 3) {
            edgeWidth = size / 3.0;
        } else {
            System.out.println("Error: Stack size: " + stackSize + ". Stack size must be between 1 and 3");
            System.exit(1);
        }
        double radius = size / 2.0;
        double hue = fill.getHue();
        double saturation = fill.getSaturation();
        double brightness = fill.getBrightness();
        Color edgeColor = Color.hsb((double)hue, (double)saturation, (double)(brightness * 0.5));
        Color innerShadowColor = Color.hsb((double)hue, (double)saturation, (double)(brightness > 0.1 ? brightness - 0.1 : 0.0));
        Group group = new Group();
        this.outerCircle = new Circle(radius, radius, radius, (Paint)edgeColor);
        group.getChildren().add((Object)this.outerCircle);
        this.innerCircle = new Circle(radius, radius, radius - edgeWidth, (Paint)fill);
        group.getChildren().add((Object)this.innerCircle);
        this.innerShadow = new InnerShadow(radius, innerShadowColor);
        this.concavity = new Circle(radius, radius, (radius - edgeWidth) * 0.75, (Paint)fill);
        this.concavity.setEffect((Effect)this.innerShadow);
        group.getChildren().add((Object)this.concavity);
        this.getChildren().add((Object)group);
    }

    public void changeMan(Man type) {
        Color fill = type == Man.BLACK ? BLACK_COLOR : WHITE_COLOR;
        double hue = fill.getHue();
        double saturation = fill.getSaturation();
        double brightness = fill.getBrightness();
        Color edgeColor = Color.hsb((double)hue, (double)saturation, (double)(brightness * 0.5));
        Color innerShadowColor = Color.hsb((double)hue, (double)saturation, (double)(brightness > 0.1 ? brightness - 0.1 : 0.0));
        this.outerCircle.setFill((Paint)edgeColor);
        this.innerCircle.setFill((Paint)fill);
        this.innerShadow.setColor(innerShadowColor);
        this.concavity.setFill((Paint)fill);
    }

    public boolean hasEffect() {
        return this.selected || this.highlighted;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void highlight() {
        this.selected = false;
        this.highlighted = true;
        InnerShadow glow = new InnerShadow();
        glow.setBlurType(BlurType.THREE_PASS_BOX);
        glow.setColor(HIGHLIGHT_COLOR);
        glow.setRadius(this.size);
        this.setEffect((Effect)glow);
        Timeline timeline = new Timeline();
        timeline.setCycleCount(-1);
        timeline.setAutoReverse(true);
        KeyValue kv = new KeyValue((WritableValue)glow.colorProperty(), (Object)Color.web((String)HIGHLIGHT_COLOR.toString(), (double)0.0));
        KeyFrame kf = new KeyFrame(Duration.millis((double)1500.0), new KeyValue[]{kv});
        timeline.getKeyFrames().add((Object)kf);
        timeline.play();
    }

    public void select() {
        this.highlighted = false;
        this.selected = true;
        InnerShadow glow = new InnerShadow();
        glow.setBlurType(BlurType.THREE_PASS_BOX);
        glow.setColor(SELECT_COLOR);
        glow.setRadius(this.size);
        this.setEffect((Effect)glow);
    }

    public void removeEffect() {
        this.selected = false;
        this.highlighted = false;
        this.setEffect(null);
    }
}

