/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.backgammon.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import tech.octopusdragon.proj.backgammon.Die;

public class DieGraphic
extends ImageView {
    private static final double DURATION = 1000.0;
    private static final int IMAGE_CHANGES = 12;
    private static final String ONE_IMAGE = "diceOne.png";
    private static final String TWO_IMAGE = "diceTwo.png";
    private static final String THREE_IMAGE = "diceThree.png";
    private static final String FOUR_IMAGE = "diceFour.png";
    private static final String FIVE_IMAGE = "diceFive.png";
    private static final String SIX_IMAGE = "diceSix.png";
    private static final String ANIMATION_DIRECTORY = "Animation";
    private static final String DICE_SOUND = "dice.wav";
    private static final Random rand = new Random();
    private static Map<Integer, Image> dieImages = new HashMap<Integer, Image>();
    private static Image[] animationImages;
    public static MediaPlayer diceSound;
    Die die;
    Timeline animation;
    boolean rolling;

    static {
        dieImages.put(1, new Image(DieGraphic.class.getClassLoader().getResourceAsStream(ONE_IMAGE)));
        dieImages.put(2, new Image(DieGraphic.class.getClassLoader().getResourceAsStream(TWO_IMAGE)));
        dieImages.put(3, new Image(DieGraphic.class.getClassLoader().getResourceAsStream(THREE_IMAGE)));
        dieImages.put(4, new Image(DieGraphic.class.getClassLoader().getResourceAsStream(FOUR_IMAGE)));
        dieImages.put(5, new Image(DieGraphic.class.getClassLoader().getResourceAsStream(FIVE_IMAGE)));
        dieImages.put(6, new Image(DieGraphic.class.getClassLoader().getResourceAsStream(SIX_IMAGE)));
        animationImages = new Image[32];
        int i = 0;
        while (i < 32) {
            DieGraphic.animationImages[i] = new Image(DieGraphic.class.getClassLoader().getResourceAsStream(String.format("%s/%02d.png", ANIMATION_DIRECTORY, i + 1)));
            ++i;
        }
        diceSound = new MediaPlayer(new Media(DieGraphic.class.getClassLoader().getResource(DICE_SOUND).toExternalForm()));
        diceSound.setOnEndOfMedia(() -> diceSound.stop());
    }

    public DieGraphic(double size) {
        this.setPreserveRatio(true);
        this.setFitWidth(size);
        this.animation = new Timeline();
        this.playNextKeyFrame();
        this.rolling = true;
    }

    public DieGraphic(double size, Die die, boolean playAnimation) {
        this.setPreserveRatio(true);
        this.setFitWidth(size);
        this.die = die;
        this.animation = new Timeline();
        if (playAnimation) {
            this.playNextKeyFrame();
            this.rolling = true;
        } else {
            this.setImage(dieImages.get(die.getValue()));
            this.rolling = false;
        }
    }

    public Die getDie() {
        return this.die;
    }

    public Timeline getAnimation() {
        return this.animation;
    }

    public void setDie(Die die) {
        this.die = die;
    }

    public void playNextKeyFrame() {
        int animationImageIndex = rand.nextInt(animationImages.length);
        KeyValue changeImage = new KeyValue((WritableValue)this.imageProperty(), (Object)animationImages[animationImageIndex]);
        this.animation.stop();
        this.animation.getKeyFrames().clear();
        this.animation.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)83.33333333333333), e -> this.playNextKeyFrame(), new KeyValue[]{changeImage}));
        this.animation.play();
    }

    public void stopAnimation() {
        this.animation.stop();
        this.setImage(dieImages.get(this.die.getValue()));
        diceSound.play();
        this.rolling = false;
    }

    public boolean isRolling() {
        return this.rolling;
    }
}

