/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.backgammon.gui;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.util.Duration;
import tech.octopusdragon.proj.backgammon.Backgammon;
import tech.octopusdragon.proj.backgammon.Die;
import tech.octopusdragon.proj.backgammon.gui.DieGraphic;
import tech.octopusdragon.proj.backgammon.gui.Piece;
import tech.octopusdragon.proj.backgammon.gui.Space;

public class BackgammonApplication
extends Application {
    static final boolean HIGHLIGHT_MOVABLE = true;
    static final int MAX_MEN_PER_POINT = 5;
    static final double GRID_SQUARE_SIZE = 60.0;
    static final double ANIMATION_DURATION = 500.0;
    static final Color OUTER_BOARD_COLOR = Color.BROWN;
    static final Color INNER_BOARD_COLOR = Color.BURLYWOOD;
    static final Color POINT1_COLOR = Color.SADDLEBROWN;
    static final Color POINT2_COLOR = Color.SANDYBROWN;
    static final String BACKGROUND_IMAGE = "background.jpg";
    static final String PIECE_SOUND = "piece.wav";
    static final String WIN_SOUND = "win.wav";
    Backgammon game;
    boolean selected;
    int selectedIndex;
    StackPane root;
    GridPane gridPane;
    List<DieGraphic> dice;
    Space[] spaces;
    Space topBar;
    Space bottomBar;
    Piece topCurPlayerPiece;
    Piece bottomCurPlayerPiece;
    MediaPlayer pieceSound;
    MediaPlayer winSound;

    public void init() {
        this.game = new Backgammon();
        this.pieceSound = new MediaPlayer(new Media(((Object)((Object)this)).getClass().getClassLoader().getResource(PIECE_SOUND).toExternalForm()));
        this.pieceSound.setOnEndOfMedia(() -> this.pieceSound.stop());
        this.winSound = new MediaPlayer(new Media(((Object)((Object)this)).getClass().getClassLoader().getResource(WIN_SOUND).toExternalForm()));
        this.winSound.setOnEndOfMedia(() -> this.winSound.stop());
    }

    public void start(Stage primaryStage) {
        this.root = new StackPane();
        this.root.setAlignment(Pos.CENTER);
        this.root.setBackground(new Background(new BackgroundImage[]{new BackgroundImage(new Image(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BACKGROUND_IMAGE)), null, null, null, null)}));
        this.buildBoard();
        this.root.getChildren().add((Object)this.gridPane);
        Scene scene = new Scene((Parent)this.root);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Backgammon");
        primaryStage.show();
    }

    public void buildBoard() {
        this.gridPane = new GridPane();
        this.gridPane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)INNER_BOARD_COLOR, null, null)}));
        this.gridPane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        int i = 0;
        while (i < 17) {
            if (i == 0 || i == 7 || i == 14 || i == 16) {
                int j = 0;
                while (j < 5) {
                    double height = 60.0;
                    if (j == 1 || j == 3) {
                        height = 300.0;
                    }
                    Rectangle square = new Rectangle(60.0, height, (Paint)OUTER_BOARD_COLOR);
                    this.gridPane.add((Node)square, i, j);
                    ++j;
                }
            } else {
                Rectangle topSquare = new Rectangle(60.0, 60.0, (Paint)OUTER_BOARD_COLOR);
                this.gridPane.add((Node)topSquare, i, 0);
                if (i == 15) {
                    Rectangle middleSquare = new Rectangle(60.0, 60.0, (Paint)OUTER_BOARD_COLOR);
                    this.gridPane.add((Node)middleSquare, i, 2);
                }
                Rectangle bottomSquare = new Rectangle(60.0, 60.0, (Paint)OUTER_BOARD_COLOR);
                this.gridPane.add((Node)bottomSquare, i, 4);
            }
            ++i;
        }
        this.spaces = new Space[26];
        i = 0;
        while (i < 26) {
            Space.StartingPlace start = i <= 12 ? Space.StartingPlace.BOTTOM : Space.StartingPlace.TOP;
            this.spaces[i] = i == 0 ? new Space(Space.StartingPlace.TOP, i, false) : (i == 25 ? new Space(Space.StartingPlace.BOTTOM, i, false) : (!this.game.board().point(i).isUnoccupied() ? new Space(start, i, true, this.game.board().point(i).menNumber(), this.game.board().point(i).menType()) : new Space(start, i, true)));
            this.spaces[i].setOnMouseClicked(new SpaceClickHandler());
            int offset = 1;
            if (i == 0 || i == 25) {
                offset = 3;
            } else if (i > 18 || i <= 6) {
                offset = 2;
            }
            if (i <= 12) {
                this.gridPane.add((Node)this.spaces[i], 12 - i + offset, 3);
            } else {
                this.gridPane.add((Node)this.spaces[i], i - 12 - 1 + offset, 1);
            }
            ++i;
        }
        this.dice = new ArrayList<DieGraphic>();
        i = 0;
        while (i < this.game.dice().size()) {
            DieGraphic dieGraphic = new DieGraphic(60.0, this.game.dice().get(i), true);
            dieGraphic.setOnMouseClicked(event -> {
                dieGraphic.stopAnimation();
                boolean foundRolling = false;
                for (DieGraphic die : this.dice) {
                    if (!die.isRolling()) continue;
                    foundRolling = true;
                    break;
                }
                if (!foundRolling) {
                    this.highlightMovablePieces();
                    Label topCurPlayerLabel = new Label("Current Player");
                    topCurPlayerLabel.setRotate(180.0);
                    this.topCurPlayerPiece = new Piece(60.0, 1, this.game.curPlayer().menType());
                    VBox topCurPlayerBox = new VBox(new Node[]{this.topCurPlayerPiece, topCurPlayerLabel});
                    topCurPlayerBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.5), new CornerRadii(5.0), new Insets(-5.0))}));
                    topCurPlayerBox.setAlignment(Pos.CENTER);
                    topCurPlayerBox.setSpacing(5.0);
                    topCurPlayerBox.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                    StackPane.setMargin((Node)topCurPlayerBox, (Insets)new Insets(10.0));
                    StackPane.setAlignment((Node)topCurPlayerBox, (Pos)Pos.TOP_LEFT);
                    this.root.getChildren().add((Object)topCurPlayerBox);
                    Label bottomCurrentPlayerLabel = new Label("Current Player");
                    this.bottomCurPlayerPiece = new Piece(60.0, 1, this.game.curPlayer().menType());
                    VBox bottomCurPlayerBox = new VBox(new Node[]{bottomCurrentPlayerLabel, this.bottomCurPlayerPiece});
                    bottomCurPlayerBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"#FFFFFF", (double)0.5), new CornerRadii(5.0), new Insets(-5.0))}));
                    bottomCurPlayerBox.setAlignment(Pos.CENTER);
                    bottomCurPlayerBox.setSpacing(5.0);
                    bottomCurPlayerBox.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                    StackPane.setMargin((Node)bottomCurPlayerBox, (Insets)new Insets(10.0));
                    StackPane.setAlignment((Node)bottomCurPlayerBox, (Pos)Pos.BOTTOM_RIGHT);
                    this.root.getChildren().add((Object)bottomCurPlayerBox);
                }
            });
            this.dice.add(dieGraphic);
            if (i == 0) {
                this.gridPane.add((Node)dieGraphic, 7, 1);
            } else {
                this.gridPane.add((Node)dieGraphic, 7, 3);
            }
            if (!this.game.hasMove()) {
                this.nextTurn();
            }
            ++i;
        }
        this.topBar = new Space(Space.StartingPlace.TOP, 0, false);
        this.topBar.setOnMouseClicked(new SpaceClickHandler());
        this.gridPane.add((Node)this.topBar, 7, 1);
        this.bottomBar = new Space(Space.StartingPlace.BOTTOM, 25, false);
        this.bottomBar.setOnMouseClicked(new SpaceClickHandler());
        this.gridPane.add((Node)this.bottomBar, 7, 3);
        for (DieGraphic die : this.dice) {
            die.toFront();
        }
    }

    public void updateDieGraphics() {
        if (!this.game.hasRolled()) {
            DieGraphic dieGraphic2;
            for (DieGraphic dieGraphic2 : this.dice) {
                this.gridPane.getChildren().remove((Object)dieGraphic2);
            }
            this.dice.clear();
            dieGraphic2 = new DieGraphic(60.0);
            this.dice.add(dieGraphic2);
            dieGraphic2.setOnMouseClicked(new DieClickHandler());
            dieGraphic2.setOnMouseEntered(new EnterHandler());
            dieGraphic2.setOnMouseExited(new ExitHandler());
            this.gridPane.add((Node)dieGraphic2, 7, 2);
        } else {
            for (DieGraphic dieGraphic : this.dice) {
                this.gridPane.getChildren().remove((Object)dieGraphic);
            }
            this.dice.clear();
            for (Die die : this.game.dice()) {
                DieGraphic dieGraphic = new DieGraphic(60.0, die, false);
                this.dice.add(dieGraphic);
            }
            int i = 0;
            while (i < this.dice.size()) {
                if (i % 2 == 0) {
                    this.gridPane.add((Node)this.dice.get(i), 7 - (int)(Math.ceil(i / 2) + 1.0), 2);
                } else {
                    this.gridPane.add((Node)this.dice.get(i), 7 + (int)(Math.ceil(i / 2) + 1.0), 2);
                }
                ++i;
            }
        }
    }

    public void nextTurn() {
        if (this.game.isOver()) {
            this.winSound.play();
        } else {
            this.game.nextPlayer();
            this.topCurPlayerPiece.changeMan(this.game.curPlayer().menType());
            this.bottomCurPlayerPiece.changeMan(this.game.curPlayer().menType());
        }
        this.updateDieGraphics();
    }

    public void highlightMovablePieces() {
        int i = 1;
        while (i <= 24) {
            if (this.game.canMove(i)) {
                this.spaces[i].highlightPiece();
                this.spaces[i].setOnMouseEntered(new EnterHandler());
                this.spaces[i].setOnMouseExited(new ExitHandler());
            }
            ++i;
        }
        if (!this.game.curPlayer().hitMen().isEmpty() && this.game.curPlayer() == Backgammon.TOP_PLAYER) {
            this.topBar.highlightPiece();
            this.topBar.setOnMouseEntered(new EnterHandler());
            this.topBar.setOnMouseExited(new ExitHandler());
        } else if (!this.game.curPlayer().hitMen().isEmpty() && this.game.curPlayer() == Backgammon.BOTTOM_PLAYER) {
            this.bottomBar.highlightPiece();
            this.bottomBar.setOnMouseEntered(new EnterHandler());
            this.bottomBar.setOnMouseExited(new ExitHandler());
        }
    }

    public void highlightMovableSpaces() {
        int i = 0;
        while (i < 26) {
            if (this.game.isValidMove(this.selectedIndex, i)) {
                this.spaces[i].setOnMouseEntered(new EnterHandler());
                this.spaces[i].setOnMouseExited(new ExitHandler());
                if (this.game.board().point(i).isUnoccupied() || this.game.board().point(i).menType() == this.game.curPlayer().menType()) {
                    this.spaces[i].highlightSpace();
                } else if (this.game.board().point(i).menType() != this.game.curPlayer().menType() && this.game.board().point(i).menNumber() == 1) {
                    this.spaces[i].highlightPiece();
                }
            }
            ++i;
        }
    }

    public void removeEffects() {
        int i = 0;
        while (i < 26) {
            int j = 0;
            while (j < 5) {
                this.spaces[i].setOnMouseEntered(null);
                this.spaces[i].setOnMouseExited(null);
                this.spaces[i].removeEffect();
                ++j;
            }
            ++i;
        }
        this.topBar.setOnMouseEntered(null);
        this.topBar.setOnMouseExited(null);
        this.topBar.removeEffect();
        this.bottomBar.setOnMouseEntered(null);
        this.bottomBar.setOnMouseExited(null);
        this.bottomBar.removeEffect();
    }

    public void moveToPoint(int index) {
        this.selected = false;
        this.removeEffects();
        if (!this.game.isValidMove(this.selectedIndex, index)) {
            this.highlightMovablePieces();
            return;
        }
        boolean capture = false;
        if (this.game.isCapture(this.selectedIndex, index)) {
            capture = true;
        }
        this.game.move(this.selectedIndex, index);
        if (capture) {
            if (this.game.curOpponent() == Backgammon.TOP_PLAYER) {
                this.topBar.add(this.game.curOpponent().menType());
            } else {
                this.bottomBar.add(this.game.curOpponent().menType());
            }
        }
        this.spaces[index].add(this.game.curPlayer().menType());
        this.pieceSound.play();
        this.updateDieGraphics();
        if (this.game.hasMove()) {
            this.highlightMovablePieces();
        } else {
            this.nextTurn();
        }
    }

    public void moveAnimation(int index) {
        double toY;
        double toX;
        double fromY;
        double fromX;
        this.selected = false;
        this.removeEffects();
        if (!this.game.isValidMove(this.selectedIndex, index)) {
            this.highlightMovablePieces();
            return;
        }
        Piece tempPlayerPiece = new Piece(60.0, 1, this.game.curPlayer().menType());
        StackPane.setAlignment((Node)tempPlayerPiece, (Pos)Pos.TOP_LEFT);
        ParallelTransition ptrans = new ParallelTransition();
        TranslateTransition ttrans = new TranslateTransition(Duration.millis((double)500.0), (Node)tempPlayerPiece);
        if (this.selectedIndex == 0) {
            fromX = this.gridPane.getLayoutX() + this.topBar.getLayoutX() + this.topBar.getLastPieceLayoutX();
            fromY = this.gridPane.getLayoutY() + this.topBar.getLayoutY() + this.topBar.getLastPieceLayoutY();
        } else if (this.selectedIndex == 25) {
            fromX = this.gridPane.getLayoutX() + this.bottomBar.getLayoutX() + this.bottomBar.getLastPieceLayoutX();
            fromY = this.gridPane.getLayoutY() + this.bottomBar.getLayoutY() + this.bottomBar.getLastPieceLayoutY();
        } else {
            fromX = this.gridPane.getLayoutX() + this.spaces[this.selectedIndex].getLayoutX() + this.spaces[this.selectedIndex].getLastPieceLayoutX();
            fromY = this.gridPane.getLayoutY() + this.spaces[this.selectedIndex].getLayoutY() + this.spaces[this.selectedIndex].getLastPieceLayoutY();
        }
        if (this.game.isCapture(this.selectedIndex, index)) {
            toX = this.gridPane.getLayoutX() + this.spaces[index].getLayoutX() + this.spaces[index].getLastPieceLayoutX();
            toY = this.gridPane.getLayoutY() + this.spaces[index].getLayoutY() + this.spaces[index].getLastPieceLayoutY();
        } else {
            toX = this.gridPane.getLayoutX() + this.spaces[index].getLayoutX() + this.spaces[index].getNextPieceLayoutX();
            toY = this.gridPane.getLayoutY() + this.spaces[index].getLayoutY() + this.spaces[index].getNextPieceLayoutY();
        }
        ttrans.setFromX(fromX);
        ttrans.setFromY(fromY);
        ttrans.setToX(toX);
        ttrans.setToY(toY);
        ptrans.getChildren().add((Object)ttrans);
        ttrans.setOnFinished(e -> {
            this.moveToPoint(index);
            this.root.getChildren().remove((Object)tempPlayerPiece);
        });
        if (this.game.isCapture(this.selectedIndex, index)) {
            Piece tempOpponentPiece = new Piece(60.0, 1, this.game.curOpponent().menType());
            StackPane.setAlignment((Node)tempOpponentPiece, (Pos)Pos.TOP_LEFT);
            double x = this.gridPane.getLayoutX() + this.spaces[index].getLayoutX() + this.spaces[index].getLastPieceLayoutX();
            double y = this.gridPane.getLayoutY() + this.spaces[index].getLayoutY() + this.spaces[index].getLastPieceLayoutY();
            tempOpponentPiece.setTranslateX(x);
            tempOpponentPiece.setTranslateY(y);
            FadeTransition ftrans = new FadeTransition(Duration.millis((double)250.0), (Node)tempOpponentPiece);
            ftrans.setDelay(Duration.millis((double)500.0));
            ftrans.setToValue(0.0);
            ptrans.getChildren().add((Object)ftrans);
            ScaleTransition strans = new ScaleTransition(Duration.millis((double)250.0), (Node)tempOpponentPiece);
            strans.setDelay(Duration.millis((double)500.0));
            strans.setByX(2.0);
            strans.setByY(2.0);
            ptrans.getChildren().add((Object)strans);
            ftrans.setOnFinished(e -> this.root.getChildren().remove((Object)tempOpponentPiece));
            this.root.getChildren().add((Object)tempOpponentPiece);
            this.spaces[index].remove();
        }
        this.root.getChildren().add((Object)tempPlayerPiece);
        if (this.selectedIndex == 0) {
            this.topBar.remove();
        } else if (this.selectedIndex == 25) {
            this.bottomBar.remove();
        } else {
            this.spaces[this.selectedIndex].remove();
        }
        ptrans.play();
    }

    public void handCursor() {
        this.root.getScene().setCursor(Cursor.HAND);
    }

    public void defaultCursor() {
        this.root.getScene().setCursor(Cursor.DEFAULT);
    }

    public static void main(String[] args) {
        BackgammonApplication.launch((String[])args);
    }

    public class DieClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            BackgammonApplication.this.game.roll();
            BackgammonApplication.this.updateDieGraphics();
            DieGraphic.diceSound.play();
            if (!BackgammonApplication.this.game.hasMove()) {
                Timeline waitTimeline = new Timeline();
                waitTimeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)2000.0), e -> BackgammonApplication.this.nextTurn(), new KeyValue[0]));
                waitTimeline.play();
            } else {
                BackgammonApplication.this.highlightMovablePieces();
            }
        }
    }

    public class EnterHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            BackgammonApplication.this.handCursor();
        }
    }

    public class ExitHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            BackgammonApplication.this.defaultCursor();
        }
    }

    public class SpaceClickHandler
    implements EventHandler<MouseEvent> {
        public void handle(MouseEvent event) {
            if (BackgammonApplication.this.selected) {
                BackgammonApplication.this.moveAnimation(((Space)((Object)event.getSource())).getPointIndex());
                if (BackgammonApplication.this.game.canMove(((Space)((Object)event.getSource())).getPointIndex())) {
                    BackgammonApplication.this.handCursor();
                } else {
                    BackgammonApplication.this.defaultCursor();
                }
            } else if (BackgammonApplication.this.game.canMove(((Space)((Object)event.getSource())).getPointIndex())) {
                BackgammonApplication.this.removeEffects();
                ((Space)((Object)event.getSource())).select();
                BackgammonApplication.this.selected = true;
                BackgammonApplication.this.selectedIndex = ((Space)((Object)event.getSource())).getPointIndex();
                BackgammonApplication.this.highlightMovableSpaces();
                BackgammonApplication.this.defaultCursor();
            }
        }
    }
}

