/*
 * Decompiled with CFR 0.152.
 */
package tech.octopusdragon.proj.backgammon;

import java.util.ArrayList;
import java.util.List;
import tech.octopusdragon.proj.backgammon.Board;
import tech.octopusdragon.proj.backgammon.Die;
import tech.octopusdragon.proj.backgammon.Man;
import tech.octopusdragon.proj.backgammon.Player;

public class Backgammon {
    public static final int NUM_DICE = 2;
    public static final Player TOP_PLAYER = Player.BLACK;
    public static final Player BOTTOM_PLAYER = Player.WHITE;
    private Board board = new Board();
    private List<Die> dice = new ArrayList<Die>();
    private Player curPlayer;
    private boolean hasRolled;
    private boolean hasMoved;

    public Backgammon() {
        int i = 0;
        while (i < 2) {
            this.dice.add(new Die());
            ++i;
        }
        do {
            i = 0;
            while (i < 2) {
                this.dice.get(i).roll();
                ++i;
            }
            if (this.dice.get(0).getValue() > this.dice.get(1).getValue()) {
                this.curPlayer = Player.BLACK;
                continue;
            }
            if (this.dice.get(0).getValue() >= this.dice.get(1).getValue()) continue;
            this.curPlayer = Player.WHITE;
        } while (this.dice.get(0).getValue() == this.dice.get(1).getValue());
        this.hasRolled = true;
        this.hasMoved = false;
        while (!this.hasMove()) {
            this.hasMoved = true;
            this.nextPlayer();
            this.hasRolled = true;
        }
    }

    public int direction(Player player) {
        if (player == TOP_PLAYER) {
            return 1;
        }
        return -1;
    }

    public int homeStart(Player player) {
        if (player == TOP_PLAYER) {
            return 19;
        }
        return 6;
    }

    public int offboard(Player player) {
        if (player == TOP_PLAYER) {
            return 25;
        }
        return 0;
    }

    public Board board() {
        return this.board;
    }

    public List<Die> dice() {
        return new ArrayList<Die>(this.dice);
    }

    public Die die(int index) {
        return this.dice.get(index);
    }

    public Player curPlayer() {
        return this.curPlayer;
    }

    public Player curOpponent() {
        if (this.curPlayer == Player.BLACK) {
            return Player.WHITE;
        }
        return Player.BLACK;
    }

    public boolean hasRolled() {
        return this.hasRolled;
    }

    public boolean hasMoved() {
        return this.hasMoved;
    }

    public void nextPlayer() {
        if (!this.hasMoved) {
            return;
        }
        this.curPlayer = this.curPlayer == Player.BLACK ? Player.WHITE : Player.BLACK;
        this.dice.clear();
        this.dice.add(new Die());
        this.dice.add(new Die());
        this.hasRolled = false;
        this.hasMoved = false;
    }

    public void roll() {
        if (this.hasRolled) {
            return;
        }
        int i = 0;
        while (i < this.dice.size()) {
            this.dice.get(i).roll();
            ++i;
        }
        if (this.dice.get(0).getValue() == this.dice.get(1).getValue()) {
            this.dice.add(new Die(this.dice.get(0).getValue()));
            this.dice.add(new Die(this.dice.get(0).getValue()));
        }
        this.hasRolled = true;
        if (!this.hasMove()) {
            this.hasMoved = true;
        }
    }

    public boolean isValidMove(int fromIndex, int toIndex) {
        if (!this.hasRolled) {
            return false;
        }
        if (this.hasMoved) {
            return false;
        }
        if (!this.curPlayer.hitMen().isEmpty() && fromIndex != this.offboard(this.curOpponent())) {
            return false;
        }
        if (fromIndex != 0 && fromIndex != 25 && this.board.point(fromIndex).menType() != this.curPlayer.menType()) {
            return false;
        }
        if (this.canBearOff() && toIndex == this.offboard(this.curPlayer)) {
            for (Die die : this.dice) {
                if (fromIndex + this.direction(this.curPlayer) * die.getValue() != toIndex) continue;
                return true;
            }
        }
        if (this.canBearOff() && (this.curPlayer == TOP_PLAYER && toIndex >= this.offboard(this.curPlayer) || this.curPlayer == BOTTOM_PLAYER && toIndex <= this.offboard(this.curPlayer))) {
            boolean hasMenAtHigherPoint = false;
            int i = fromIndex - this.direction(this.curPlayer);
            while (i != this.homeStart(this.curPlayer) - this.direction(this.curPlayer)) {
                if (this.board.point(i).menType() == this.curPlayer.menType()) {
                    hasMenAtHigherPoint = true;
                    break;
                }
                i -= this.direction(this.curPlayer);
            }
            if (hasMenAtHigherPoint) {
                return false;
            }
            if (this.curPlayer == TOP_PLAYER) {
                for (Die die : this.dice) {
                    if (fromIndex + this.direction(this.curPlayer) * die.getValue() < toIndex) continue;
                    return true;
                }
            } else if (this.curPlayer == BOTTOM_PLAYER) {
                for (Die die : this.dice) {
                    if (fromIndex + this.direction(this.curPlayer) * die.getValue() > toIndex) continue;
                    return true;
                }
            }
        } else {
            if (!(this.canBearOff() || toIndex > 0 && toIndex < 25)) {
                return false;
            }
            if (this.board.point(toIndex).menType() == this.curOpponent().menType() && this.board.point(toIndex).menNumber() > 1) {
                return false;
            }
        }
        for (Die die : this.dice) {
            if (fromIndex + this.direction(this.curPlayer) * die.getValue() != toIndex) continue;
            return true;
        }
        return false;
    }

    public boolean isCapture(int fromIndex, int toIndex) {
        return this.isValidMove(fromIndex, toIndex) && this.board.point(toIndex).menType() == this.curOpponent().menType() && this.board.point(toIndex).menNumber() == 1;
    }

    public boolean isBearingOffMove(int fromIndex, int toIndex) {
        return this.canBearOff() && this.isValidMove(fromIndex, toIndex) && (this.curPlayer == TOP_PLAYER && toIndex >= this.offboard(this.curPlayer) || this.curPlayer == BOTTOM_PLAYER && toIndex <= this.offboard(this.curPlayer));
    }

    public boolean canMove(int index) {
        for (Die die : this.dice) {
            if (!this.isValidMove(index, index + this.direction(this.curPlayer) * die.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean hasMove() {
        int i = 1;
        while (i <= 24) {
            if (this.canMove(i)) {
                return true;
            }
            ++i;
        }
        return !this.curPlayer.hitMen().isEmpty() && this.canMove(this.offboard(this.curOpponent()));
    }

    public boolean canBearOff() {
        if (!this.curPlayer.hitMen().isEmpty()) {
            return false;
        }
        if (this.curPlayer == TOP_PLAYER) {
            int i = 1;
            while (i < this.homeStart(this.curPlayer)) {
                if (this.board.point(i).menType() == this.curPlayer.menType()) {
                    return false;
                }
                ++i;
            }
        } else {
            int i = 24;
            while (i > this.homeStart(this.curPlayer)) {
                if (this.board.point(i).menType() == this.curPlayer.menType()) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    public boolean isOver() {
        boolean whiteFound = false;
        boolean blackFound = false;
        int i = 1;
        while (i <= 24) {
            if (this.board.point(i).menType() == Man.BLACK) {
                blackFound = true;
            } else if (this.board.point(i).menType() == Man.WHITE) {
                whiteFound = true;
            }
            if (blackFound && whiteFound) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void move(int fromIndex, int toIndex) {
        for (Die die : this.dice) {
            if (fromIndex + this.direction(this.curPlayer) * die.getValue() != toIndex && (!this.isBearingOffMove(fromIndex, toIndex) || !this.isValidMove(fromIndex, toIndex) || die.getValue() < Math.abs(fromIndex - toIndex))) continue;
            if (fromIndex == 0 || fromIndex == 25) {
                this.curPlayer.hitMen().pop();
            } else {
                this.board.point(fromIndex).remove();
            }
            if (this.board.point(toIndex).menType() == this.curOpponent().menType() && this.board.point(toIndex).menNumber() == 1) {
                this.curOpponent().hitMen().push(this.board.point(toIndex).remove());
            }
            this.board.point(toIndex).add(this.curPlayer.menType());
            this.dice.remove(die);
            break;
        }
        if (!this.hasMove()) {
            this.dice.clear();
            this.hasMoved = true;
        }
    }
}

